/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import potionstudios.byg.mixin.access.WeightedListAccess;
import potionstudios.byg.util.codec.CollectionCodec;

public final class LevelBiomeTracker {
    private final Map<class_5321<class_1959>, Collection<class_5321<class_1937>>> biomeDimensions = new Object2ObjectOpenHashMap();
    private final Map<class_5321<class_1959>, ObjectOpenHashSet<class_5321<class_1299<?>>>> biomeMobs;
    public static LevelBiomeTracker client_instance = null;
    public static final Codec<LevelBiomeTracker> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_2378.field_25298), new CollectionCodec(class_5321.method_39154((class_5321)class_2378.field_25114), ObjectOpenHashSet::new)).fieldOf("biomes_for_level").forGetter(levelBiomeTracker -> levelBiomeTracker.biomesForLevel), (App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_2378.field_25114), new CollectionCodec(class_5321.method_39154((class_5321)class_2378.field_25107), ObjectOpenHashSet::new)).fieldOf("biome_mobs").forGetter(levelBiomeTracker -> levelBiomeTracker.biomeMobs)).apply((Applicative)builder, LevelBiomeTracker::new));
    private final Map<class_5321<class_1937>, ObjectOpenHashSet<class_5321<class_1959>>> biomesForLevel;

    public LevelBiomeTracker(Map<class_5321<class_1937>, ObjectOpenHashSet<class_5321<class_1959>>> biomesForLevel, Map<class_5321<class_1959>, ObjectOpenHashSet<class_5321<class_1299<?>>>> biomeMobs) {
        this.biomesForLevel = biomesForLevel;
        biomesForLevel.forEach((level, biomes) -> {
            for (class_5321 biome : biomes) {
                this.biomeDimensions.computeIfAbsent((class_5321<class_1959>)biome, key -> new ObjectOpenHashSet()).add(level);
            }
        });
        this.biomeMobs = biomeMobs;
    }

    public static LevelBiomeTracker fromServer(MinecraftServer server) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap entitySpawns = new Object2ObjectOpenHashMap();
        for (class_3218 level : server.method_3738()) {
            ObjectOpenHashSet biomes = (ObjectOpenHashSet)map.computeIfAbsent((Object)level.method_27983(), key -> new ObjectOpenHashSet());
            for (class_6880 possibleBiome : level.method_14178().method_12129().method_12098().method_28443()) {
                class_5321 biomeResourceKey = (class_5321)possibleBiome.method_40230().orElseThrow();
                biomes.add((Object)biomeResourceKey);
                for (class_1311 category : class_1311.values()) {
                    class_6012 mobs = ((class_1959)possibleBiome.comp_349()).method_30966().method_31004(category);
                    ((WeightedListAccess)mobs).byg_getItems().stream().map(spawnerData -> spawnerData.field_9389).map(entityType -> (class_5321)class_2378.field_11145.method_29113(entityType).orElseThrow()).forEach(entityTypeResourceKey -> ((ObjectOpenHashSet)entitySpawns.computeIfAbsent((Object)biomeResourceKey, key -> new ObjectOpenHashSet())).add(entityTypeResourceKey));
                }
            }
        }
        return new LevelBiomeTracker((Map<class_5321<class_1937>, ObjectOpenHashSet<class_5321<class_1959>>>)map, (Map<class_5321<class_1959>, ObjectOpenHashSet<class_5321<class_1299<?>>>>)entitySpawns);
    }

    public Map<class_5321<class_1937>, ObjectOpenHashSet<class_5321<class_1959>>> biomesForLevel() {
        return this.biomesForLevel;
    }

    public Map<class_5321<class_1959>, Collection<class_5321<class_1937>>> biomeDimensions() {
        return this.biomeDimensions;
    }

    public Map<class_5321<class_1959>, ObjectOpenHashSet<class_5321<class_1299<?>>>> getBiomeMobs() {
        return this.biomeMobs;
    }

    public static interface Access {
        public LevelBiomeTracker levelBiomeTracker();
    }
}

